export default function(eleventyConfig) {
  // Copy static assets (CSS, images, etc.)
  eleventyConfig.addPassthroughCopy({ "src/assets": "assets" });

  // Copy Web Awesome CSS from node_modules to public/vendor
  eleventyConfig.addPassthroughCopy({
    "node_modules/@awesome.me/webawesome/dist/styles/webawesome.css": "vendor/webawesome.css"
  });

  return {
    dir: {
      input: "src",
      includes: "_includes",
      data: "_data",
      output: "public"
    },
    htmlTemplateEngine: "njk",
    markdownTemplateEngine: "njk"
  };
}